# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 3
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR3_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to establish goodwill
    if current_round == 1:
        return "C"
    
    # Check opponent's code for hardcoded defection in Round 10
    opponent_likely_defect_10 = ("current_round == 10" in opponent_program_code and "return 'D'" in opponent_program_code)
    
    # Mid-Game Tit-for-Tat (Rounds 2-7)
    if 2 <= current_round <= 7:
        if opp_history[-1] == "D":
            return "D"
        else:
            return "C"
    
    # Late-Game Strategy (Rounds 8-10)
    if current_round >= 8:
        # Rounds 8-9: Defect if opponent defected >=2 times in last 3 rounds
        if current_round <= 9:
            last_3_rounds = opp_history[-3:] if len(opp_history) >= 3 else opp_history
            defect_count = last_3_rounds.count("D")
            if defect_count >= 2:
                return "D"
            else:
                return "C"
        # Round 10: Defect if opponent likely to defect or defected in Round 9
        elif current_round == 10:
            if opponent_likely_defect_10 or (len(opp_history) >= 9 and opp_history[-1] == "D"):
                return "D"
            else:
                return "C"
    
    # Default fallback (shouldn't reach here)
    return "C"